<?php 
    //QUERY PARA LOS USUARIOS RUT DATALIST.
    $sql_habitac = "SELECT * FROM habitaciones WHERE estado = 'Activo'";
    $queryhabitac = mysqli_query($con, $sql_habitac);

    $sql_cliente = "SELECT * FROM usuario WHERE estado = 'Activo'";
    $querycliente = mysqli_query($con, $sql_cliente);
    //QUERY PARA LOS USUARIOS CORREO DATALIST.
    /*$sql_usuarios_correo = "SELECT * FROM usuario WHERE id_sucursal = '$id_sucursal_usuario' AND estado <> 'Eliminado'";
    $queryusuarios_correo = mysqli_query($con, $sql_usuarios_correo);

    //LISTADO DE SUCURSALES
    $sql_sucursal = "SELECT * FROM sucursal";
    $querysucursal = mysqli_query($con, $sql_sucursal);*/
?>
<script type="text/javascript">
        function puntomil() {
            const monto_matricula = document.getElementById("monto_matricula");
            const monto_mensualidad = document.getElementById("monto_mensualidad");
            let valor = monto_matricula.value.replace(/[.]/g, '') || '0'; 
            monto_matricula.value = valor.replace(/^0+(?=\d)/, '').replace(/\B(?=(\d{3})+(?!\d))/g, '.');

            let valor2 = monto_mensualidad.value.replace(/[.]/g, '') || '0'; 
            monto_mensualidad.value = valor2.replace(/^0+(?=\d)/, '').replace(/\B(?=(\d{3})+(?!\d))/g, '.');
        }
</script>
<!-- SUB FORMULARIO PARA REGISTRAR CLIENTE DENTRO DEL FORMULARIO RECEPCION  -->
<div class="modal fade" id="registroUsuario" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
  <div class="modal-dialog modal-dialog-centered modal-lg" role="document"> <!-- Agregamos modal-lg para hacerlo más grande -->
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="exampleModalLabel">Registrar Nueva Reserva</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body ">
        <!-- Formulario -->
        <form class="user" id="registroForm">
          <!-- Cliente (datos relevantes) -->
            <div class="form-group row div-container">   
                <input type="text" name="id_habitacion_post" id="id_habitacion_post" value="" hidden readonly>
                <input type="text" name="n_habitacion" id="n_habitacion" value="" hidden readonly>
                <input type="text" name="precio_dia" id="precio_dia" value="" hidden readonly>
                <input type="text" name="precio_dia2" id="precio_dia2" value="" hidden readonly>
                                                <div class="col-sm-6 input-div">
                                                    <select class="form-control campo_required" id="nombre_habitacion" name="nombre_habitacion" style="height: 58px;" onchange="processSelectedOption();">
                                                        <option value="">Seleccionar Habitación</option>
                                                        <?php while ($rowhabitac = mysqli_fetch_assoc($queryhabitac)) { ?>
                                                            <option value="<?php echo $rowhabitac['id_habitacion']." || ".$rowhabitac['precio_por_dia']." || ".$rowhabitac['precio_por_dia2']." || ".$rowhabitac['nombre_habitacion']." || ".$rowhabitac['numero']; ?>">
                                                                <?php echo $rowhabitac['nombre_habitacion'] . " " . $rowhabitac['numero']; ?>
                                                            </option>
                                                        <?php } ?>
                                                    </select>
                                                </div> 
                                                <div class="col-sm-6 input-div">
                                                    <select class="form-control campo_required" id="clientes" name="clientes" style="height: 58px;">
                                                        <option value="">Seleccionar Cliente</option>
                                                        <?php while ($rowcliente = mysqli_fetch_assoc($querycliente)) { ?>
                                                            <option value="<?php echo $rowcliente['id_usuario']; ?>">
                                                                <?php echo $rowcliente['nombre'] . " " . $rowcliente['apellido'] . " " . $rowcliente['rut']; ?>
                                                            </option>
                                                        <?php } ?>
                                                    </select>
                                                </div> 
                                                
                                                <div class="col-sm-6 ">
                                                    <div class="row mb-3">
                                                        <label for="fecha_entrada" class="col-sm-5 col-form-label" style="margin-top: 10px;">Fecha de Entrada</label>
                                                        <div class="col-sm-7">
                                                            <input type="text" class="form-control" onchange="validarFechas(); calcular_hospedaje()" id="fecha_entrada" name="fecha_entrada" style="margin-top: 8px;" required>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-sm-6 ">
                                                    <div class="row mb-3">

                                                        <label for="fecha_salida" class="col-sm-5 col-form-label" style="margin-top: 10px;">Fecha de Salida</label>
                                                        <div class="col-sm-7">
                                                            <input type="text" class="form-control" onchange="calcular_hospedaje()" style="margin-top: 10px;" id="fecha_salida" name="fecha_salida" required>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-sm-3 form-floating form-label-inside input-div">
                                                    <input type="text" class="form-control" oninput="actualizar_total()" id="cantidad_personas" name="cantidad_personas" placeholder=" ">
                                                    <label for="cantidad_personas" class="col-sm-12">Cantidad Personas</label>
                                                </div>
                                                <div class="col-sm-3 form-floating form-label-inside input-div">
                                                    <input type="text" class="form-control" oninput="puntomil()" id="telefono" name="telefono" placeholder=" ">
                                                    <label for="telefono" class="col-sm-12">Teléfono</label>
                                                </div>
                                                <div class="col-sm-3 form-floating form-label-inside input-div">
                                                    <select class="form-control" id="hora_llegada" name="hora_llegada">
                                                        <option value="">Seleccionar hora</option>
                                                        <?php 
                                                        for ($i = 0; $i < 24; $i++) {
                                                            $hora = str_pad($i, 2, "0", STR_PAD_LEFT) . ":00";
                                                            echo "<option value='$hora'>$hora</option>";
                                                        }
                                                        ?>
                                                    </select>
                                                    <label for="hora_llegada" class="col-sm-12">Hora de Llegada</label>
                                                </div>
                                                <div class="col-sm-3 form-floating form-label-inside input-div">
                                                    <select class="form-control" id="tipo_cliente" name="tipo_cliente">
                                                        <option value="">Tipo Cliente</option>
                                                        <option value="Empresa">Empresa</option>
                                                        <option value="Turismo">Turismo</option>
                                                        <option value="Esporádico">Esporádico</option>       
                                                    </select>
                                                    <label for="tipo_cliente" class="col-sm-12">Tipo Cliente</label>
                                                </div>
                                                <div class="col-sm-6 form-floating form-label-inside input-div">  
                                                    <textarea class="form-control" placeholder="Descripción" name="descripcion" id="descripcion"></textarea>
                                                    <label for="descripcion" class="col-sm-9">Descripción (Opcional)</label>
                                                </div> 
                                                <div class="col-sm-3 form-floating form-label-inside input-div">
                                                    <select class="form-control" id="tipo_pago" name="tipo_pago">
                                                        <option value="">Tipo de Pago</option>
                                                        <option value="Boleta">Boleta</option>
                                                        <option value="Factura">Factura</option>
                                                        <option value="Sin Boleta">Sin Boleta</option>       
                                                    </select>
                                                    <label for="tipo_pago" class="col-sm-12">Tipo de Pago</label>
                                                </div>
                                                <div class="col-sm-3 form-floating form-label-inside input-div">
                                                    <input type="text" readonly class="form-control" value="0" id="total_a_pagar" name="total_a_pagar" placeholder="Valor a pagar" required>
                                                    <label for="total_a_pagar" class="col-sm-12">Total a Pagar</label>
                                                </div>
            </div>      <br>      
          <!-- Botones para guardar y cerrar el formulario 
            QUITÉ EL ONCLICK, PARA FUNCIONAMIENTO, AGREGAR ONCLICK FUNCTION.-->
          <div class="form-group d-flex justify-content-center align-items-center"><br>
            <button type="button" class="btn btn-primary form-control" id="guardarBtn" style="margin: 5px;" onclick="registrarReserva()">Registrar Reserva</button>
            <!--<button type="button" class="btn btn-primary form-control" id="guardarBtn" style="margin: 5px;" onclick="registrarReserva()">Registrar Reserva</button>-->
            <button type="button" class="btn btn-secondary form-control" style="margin: 5px;" data-bs-dismiss="modal">Cerrar</button>
          </div>
        </form>
      </div>
    </div>
  </div>
</div>

<script>
    // Inicialización de fechas no disponibles
    var fechasNoDisponibles = [];
    $(function() {
        $.fn.datepicker.dates['es'] = {
            days: ["Domingo", "Lunes", "Martes", "Miércoles", "Jueves", "Viernes", "Sábado"],
            daysShort: ["Dom", "Lun", "Mar", "Mie", "Jue", "Vie", "Sab"],
            daysMin: ["Dom", "Lun", "Mar", "Mie", "Jue", "Vie", "Sáb"],
            months: ["Enero", "Febrero", "Marzo", "Abril", "Mayo", "Junio", "Julio", "Agosto", "Septiembre", "Octubre", "Noviembre", "Diciembre"],
            monthsShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
            today: "Hoy",
            clear: "Borrar",
            format: "dd/mm/yyyy",
            titleFormat: "MM yyyy", /* Leverages same syntax as 'format' */
            weekStart: 1
        };
        $('#fecha_entrada').datepicker({
            startDate: new Date(),
            endDate: '+30d',
            autoclose: true,
            todayHighlight: true,
            language: 'es',
            beforeShowDay: function(date) {
                var formattedDate = date.getDate().toString().padStart(2, '0') + '/' + (date.getMonth() + 1).toString().padStart(2, '0') + '/' + date.getFullYear();
                if (fechasNoDisponibles.includes(formattedDate)) {
                    return {classes: 'date-disabled', tooltip: 'Fecha no disponible'};
                } else {
                    return {};
                }
            }
        }).on('changeDate', function (e) {
            var startDate = e.date;
            $('#fecha_salida').datepicker('setStartDate', startDate);
            var endDate = new Date(startDate);
            endDate.setDate(startDate.getDate() + 30);
            var firstUnavailableDate = fechasNoDisponibles.find(d => new Date(d.split('/').reverse().join('-')) >= startDate);
            if (firstUnavailableDate) {
                endDate = new Date(new Date(firstUnavailableDate.split('/').reverse().join('-')).setDate(new Date(firstUnavailableDate.split('/').reverse().join('-')).getDate() - 1));
            }            
            $('#fecha_salida').datepicker('setEndDate', endDate);
            // Validación para resetear fecha de salida si está antes que la de entrada
            var fechaSalida = $('#fecha_salida').datepicker('getDate');
            if (fechaSalida && fechaSalida <= startDate) {
                $('#fecha_salida').val('').datepicker('update');
            }
        });
        $('#fecha_salida').datepicker({
            startDate: new Date(),
            autoclose: true,
            todayHighlight: true,
            language: 'es',
            beforeShowDay: function(date) {
                var formattedDate = date.getDate().toString().padStart(2, '0') + '/' + (date.getMonth() + 1).toString().padStart(2, '0') + '/' + date.getFullYear();
                if (fechasNoDisponibles.includes(formattedDate)) {
                    return {classes: 'date-disabled', tooltip: 'Fecha no disponible'};
                } else {
                    return {};
                }
            }
        }).on('changeDate', function (e) {
            var fechaEntrada = $('#fecha_entrada').datepicker('getDate');
            var fechaSalida = e.date;
            // Validación para resetear fecha de salida si está antes que la de entrada********************************************************************IMPORTANTE
            if (fechaEntrada && fechaSalida < fechaEntrada) {
                $('#fecha_salida').val('').datepicker('update');
            }
        });
    });
    function validarFechas() {
        const fechaEntradaInput = document.getElementById("fecha_entrada").value;
        const fechaSalidaInput = document.getElementById("fecha_salida");
        // Verificar que ambas fechas tengan formato válido
        if (fechaEntradaInput && fechaSalidaInput.value) {
            const fechaEntrada = convertirFecha(fechaEntradaInput);
            const fechaSalida = convertirFecha(fechaSalidaInput.value);
            // Validar si la fecha de entrada es posterior a la fecha de salida
            if (fechaEntrada && fechaSalida && fechaEntrada > fechaSalida) {
                fechaSalidaInput.value = ""; // Limpiar el campo de fecha_salida
            }
        }
    }
    function convertirFecha(fecha) {
        const partes = fecha.split('/');
        if (partes.length === 3) {
            const [dia, mes, anio] = partes.map(Number);
            if (!isNaN(dia) && !isNaN(mes) && !isNaN(anio)) {
                return new Date(anio, mes - 1, dia);
            }
        }
        return null; // Retorna null si el formato no es válido
    }


    function processSelectedOption() {
        const selectElement = document.getElementById('nombre_habitacion');
        const selectedValue = selectElement.value;
        if (selectedValue) {
            const [idHabitacion, precioDia, precioDia2, nombreHabitacion, numero] = selectedValue.split(' || ');

            document.getElementById('precio_dia').value = precioDia;
            document.getElementById('precio_dia2').value = precioDia2;
            document.getElementById('fecha_entrada').value = "";
            document.getElementById('fecha_salida').value = "";
            document.getElementById('total_a_pagar').value = "0";
            // Llamar a las funciones con el id de la habitación
            loadUnavailableDates(idHabitacion);
        }
    }
    function loadUnavailableDates(idHabitacion) {
        $.ajax({
            url: 'obtener_fechas.php',
            type: 'GET',
            data: { id_habitacion: idHabitacion },
            success: function(response) {
                fechasNoDisponibles = JSON.parse(response);
                $('#fecha_entrada, #fecha_salida').datepicker('update');
            },
            error: function() {
                console.error('Error al obtener las fechas no disponibles');
            }
        });
    }
    // Función para calcular el hospedaje
    function calcular_hospedaje() {
        const fechaEntradaInput = document.getElementById("fecha_entrada").value;
        const fechaSalidaInput = document.getElementById("fecha_salida").value;
        const cantidad_personasInput = document.getElementById("cantidad_personas").value;
        const precioDiaInput = document.getElementById("precio_dia").value;
        const precioDia2Input = document.getElementById("precio_dia2").value;
        // Verificar que ambas fechas y el precio por día tengan formato válido
        if (fechaEntradaInput && fechaSalidaInput && precioDiaInput && precioDia2Input) {
            const fechaEntrada = convertirFecha(fechaEntradaInput);
            const fechaSalida = convertirFecha(fechaSalidaInput);
            if (fechaEntrada && fechaSalida && fechaEntrada <= fechaSalida) { // Asegurar que la fecha de entrada sea menor o igual a la fecha de salida
                const diffTime = Math.abs(fechaSalida - fechaEntrada);
                const diffDays = Math.ceil(diffTime / (1000 * 60 * 60 * 24)) + 1; // Convertir la diferencia en días, +1 para incluir el día de salida
                // Convertir el precio por día a entero quitando los puntos
                const precioDia = parseInt(precioDiaInput.replace(/\./g, ''), 10);
                const precioDia2 = parseInt(precioDia2Input.replace(/\./g, ''), 10);
                // Calcular el total a pagar
                let total = diffDays * precioDia;
                if (cantidad_personasInput > 1 && precioDia2Input > 1) {
                    total = diffDays * precioDia2;
                }
                // Asignar el resultado al input de id "total_a_pagar" con formato de miles
                document.getElementById("total_a_pagar").value = total.toLocaleString('es-ES');
            } else {
                document.getElementById("total_a_pagar").value = "0";
            }
        }
    }
    function actualizar_total() {
        calcular_hospedaje();
    }
    // Llamar a calcular_hospedaje() cuando se cambien las fechas o el precio por día
    document.getElementById("fecha_entrada").addEventListener("change", calcular_hospedaje);
    document.getElementById("fecha_salida").addEventListener("change", calcular_hospedaje);
    document.getElementById("precio_dia").addEventListener("input", calcular_hospedaje);
    document.getElementById("precio_dia2").addEventListener("input", calcular_hospedaje);
    document.getElementById("cantidad_personas").addEventListener("input", actualizar_total);
</script>



<script>
function registrarReserva() {
    document.getElementById("guardarBtn").disabled = true;

    // Obtener los valores de los campos del formulario
    var id_habitacion = $('#id_habitacion_post').val();
    var n_habitacion = $('#n_habitacion').val();
    var precio_dia = $('#precio_dia').val();
    var nombre_habitacion = $('#nombre_habitacion').val();
    var cliente = $('#clientes').val();
    var fecha_entrada = $('#fecha_entrada').val();
    var fecha_salida = $('#fecha_salida').val();
    var cantidad_personas = $('#cantidad_personas').val();
    var telefono = $('#telefono').val();
    var descripcion = $('#descripcion').val();
    var total_a_pagar = $('#total_a_pagar').val();

    // Validar los campos requeridos
    if (!nombre_habitacion) {
        Swal.fire({
            title: "Error",
            text: "Por favor, seleccione una habitación.",
            icon: "warning",
            confirmButtonColor: "#2a3042",
            confirmButtonText: "Aceptar"
        });
        document.getElementById("guardarBtn").disabled = false;
        return false;
    }
    if (!cliente) {
        Swal.fire({
            title: "Error",
            text: "Por favor, seleccione un cliente.",
            icon: "warning",
            confirmButtonColor: "#2a3042",
            confirmButtonText: "Aceptar"
        });
        document.getElementById("guardarBtn").disabled = false;
        return false;
    }
    if (!fecha_entrada) {
        Swal.fire({
            title: "Error",
            text: "Por favor, ingrese la fecha de entrada.",
            icon: "warning",
            confirmButtonColor: "#2a3042",
            confirmButtonText: "Aceptar"
        });
        document.getElementById("guardarBtn").disabled = false;
        return false;
    }
    if (!fecha_salida) {
        Swal.fire({
            title: "Error",
            text: "Por favor, ingrese la fecha de salida.",
            icon: "warning",
            confirmButtonColor: "#2a3042",
            confirmButtonText: "Aceptar"
        });
        document.getElementById("guardarBtn").disabled = false;
        return false;
    }

    // Enviar datos si todas las validaciones pasan
    $.ajax({
        type: 'POST',
        url: 'registro_reserva.php', // Nombre del archivo PHP para procesar el formulario
        data: {
            id_habitacion: id_habitacion,
            n_habitacion: n_habitacion,
            precio_dia: precio_dia,
            nombre_habitacion: nombre_habitacion,
            cliente: cliente,
            fecha_entrada: fecha_entrada,
            fecha_salida: fecha_salida,
            cantidad_personas: cantidad_personas,
            telefono: telefono,
            descripcion: descripcion,
            total_a_pagar: total_a_pagar
        },
        success: function(response) {
            var responseData = response.split("success");

            if (responseData.length > 1) {
                Swal.fire({
                    title: "Registro exitoso",
                    text: "La reserva fue registrada correctamente.",
                    icon: "success",
                    confirmButtonColor: "#2a3042",
                    confirmButtonText: "Aceptar"
                }).then((result) => {
                    if (result.isConfirmed) {
                        $('#registroForm')[0].reset();
                        document.getElementById("guardarBtn").disabled = false;
                        location.reload();
                    }
                });
            } else {
                Swal.fire({
                    title: "Error",
                    text: response,
                    icon: "error",
                    confirmButtonColor: "#2a3042",
                    confirmButtonText: "Aceptar"
                });
                document.getElementById("guardarBtn").disabled = false;
            }
        }
    });
}


</script>